#ifndef __CParameter__
#define __CParameter__

#include "../Basics/CCountedObject.hpp"
#include "../Basics/CString.hpp"
#include "../Basics/CDouble.hpp"

//	===========================================================================

using Exponent::Basics::CCountedObject;
using Exponent::Basics::CString;
using Exponent::Basics::CDouble;

//	===========================================================================

namespace Exponent
{
	namespace MathTools
	{
		/**
		 * @class CParameter CParameter.hpp
		 * @brief Maps a 0 - 1.0 double to a new range
		 *
		 * @date 13/11/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Added new static functions
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CParameter.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CParameter : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Constructor
			 */
			CParameter();

			/**
			 * Construction
			 * @param min The min value
			 * @param max The max value
			 * @param value The value to convert
			 */
			CParameter(const double min, const double max, const double value);

			/**
			 * Destructor
			 */
			virtual ~CParameter();

//	===========================================================================

			/**
			 * Set the range to map to
			 * @param min The min value that can be reached by the parameter
			 * @param max The max value that can be reached by the parameter
			 * @deprecated
			 */
			virtual void setRange(const double min, const double max);

			/**
			 * Get the value
			 * @param text A text representation of the parameter
			 * @deprecated
			 */
			virtual void getValue(CString &text) const;

			/**
			 * Get the value
			 * @retval double The value
			 * @deprecated
			 */
			virtual double getValue() const;

			/**
			 * Set the value
			 * @param value The value as a normalised 0 - 1 double
			 * @deprecated
			 */
			virtual void setValue(const double value);

			/**
			 * Set a new value and return the computed value
			 * @param value The value as a normalised 0 - 1 double
			 * @retval double The value computed
			 * @deprecated
			 */
			virtual double setAndGetValue(const double value);

//	===========================================================================

			/**
			 * Covert a value to an integer
			 * @param min The minimum value (negatives are acceptable)
			 * @param max The maximum value (negatives are acceptable)
			 * @param value The value to convert to the index
			 * @retval long The converted index in range of min - max
			 */
			static long doubleToLong(const long min, const long max, const double value);

			/**
			 * Convert an integer to a value
			 * @param min The minimum value (negatives are acceptable)
			 * @param max The maximum value (negatives are acceptable)
			 * @param index The index to convert to the value
			 */
			static double longToDouble(const long min, const long max, const long index);

			/**
			 * Convert a double to a differently mapped double range
			 * @param min The minimum value (negatives are acceptable)
			 * @param max The maximum value (negatives are acceptable)
			 * @param value The value to convert to the remapped value. must be in range 0 - 1
			 * @retval double The remapped value
			 */
			static double doubleToDouble(const double min, const double max, const double value);

//	===========================================================================

		protected:

//	===========================================================================

			double m_out;				/**< The output value */
			double m_min;				/**< The min value */
			double m_max;				/**< The max value */
			double m_difference;		/**< The difference */
		};
	}
}
#endif	// End of CParameter.hpp